import synt
from unify import main_unifier


fixed_variables = ['a','b','c','d','e','\\ovar','\\q^{1}_{0}','\\q^{2}_{0}','\\v^{1}_{0}','\\v^{2}_{0}']

def search_rules(conclusion, premises, signature, takenvars,localfixedvars, 
					 linemax = None, rules=None, debug_flag = False):

# A signature contains two kinds of entries: constants and references.
# References begin with either a dollar sign, a numeral, or a period.
# Constants are not allowed to contain any of these symbols.
# The conclusion may be repeated in a rule.

	save_varnum = synt.newvarnum	
	takenvars_copy = takenvars[:]
	for rule in rules:
		if linemax and rule.linenum > linemax:
			break
		synt.newvarnum = save_varnum
		takenvars = takenvars_copy[:]
		rule_sig = rule.signature
		vdash_spot = rule_sig.index('\\C')
		rule_hyp_list = rule.body[:vdash_spot]
		if len(rule_hyp_list) != len(signature):
			continue	
		punct_mismatch = True 
		for i,x in enumerate(signature):
			if x == rule_sig[i]:
				pass
			elif x in synt.reference_punctuator_list:
				break
			elif rule_sig[i] in synt.reference_punctuator_list:
				break
		else:
			punct_mismatch = False
		if punct_mismatch:
			continue
		for x in rule.allvars:
			if x in takenvars:
				freshvarsub = synt.freshsub(rule.allvars,takenvars)	
				r = synt.subst(freshvarsub[0],freshvarsub[1], rule.body)
				break
		else:
			r = rule.body
			freshvarsub = []
		goals = []
		for i in range(len(rule.body) - vdash_spot -1):
			goals.append(conclusion)
		instance = premises  + goals

		rulefixedvars = []
		for y in rule.allvars:
			if y in fixed_variables:   # Globally defined for rules of inference 
				if freshvarsub:
					rulefixedvars.append(synt.subst(freshvarsub[0],freshvarsub[1], y))
				else:
					rulefixedvars.append(y)
		
		form = []
		for i in range(len(rule_sig)):
			if rule_sig[i] == '$':
				if r[i][0][0] in [10,11]:
					form.append(r[i][1])
				else:
					form.append(r[i])
#		print("form = ", form)
#		print("inst = ", instance)
#		print("line number = ", rule.linenum)
		rulem = main_unifier(form, instance, 
										localfixedvars + rulefixedvars,debug_flag)
		if rulem: 
			match_found = Match(rulem[1],rulem[0])
			match_found.inferencerule = rule
			match_found.rulesubst = freshvarsub
			match_found.rulefile = rule.filename
			match_found.linenum = rule.linenum
			return match_found

	return 0


class Match(object):
	def __init__(self, subst,caseflags):
		self.subst = subst
		self.rulesubst = []
		self.caseflags = hex(caseflags)
		self.inferencerule = []
		self.tracefun = None
		self.relvcheck = None
		self.rulefile = ''
		self.linenum = 0 

	def __str__(self):
		retstring = ''	
		for s in self.subst:
			retstring = s + " : " + str(self.subst[s]) + "\n"
		return retstring 
			
