
import pattern, copy
import synt , prop

class Document:

	def __init__(self, linelist,mathonly=False):
		self.linelist = linelist
		self.blocklist = build_blocklist(linelist)	
		self.proofdict = {}          # Dictionary of proofs (class: Proof)
		self.propdict = {}           # Dictionary of propositions
		self.infruledict = {}        # Dictionary of inference rules 
		self.axiomnumlist = []       # List of axiom labels. 
		self.old_defnumlist = []     # List of definition labels.
		self.new_defnumlist = []     # List of definition labels.
		self.derivnumlist = []
		self.shortproofnumlist = []
		self.fullproofnumlist  = []
		self.proofnumlist = []
		self.parse_all(mathonly)
		self.linelist = []
		self.blocklist = []
	#
	# Attributes used by check but not stored
	#
		self.rulelist = []
		self.basic_ref = {}          # Dictionary of other references
		self.prop_ref = {}           # Dictionary of references within document


	def __str__(self):
		n_defs = len(self.old_defnumlist) + len(self.new_defnumlist)
		n_proofs = len(self.shortproofnumlist) + len(self.fullproofnumlist)
		n_unproved = len(self.propdict) - n_proofs  - n_defs
		n_derivs = len(self.derivnumlist)
		assert len(self.proofdict) == n_proofs + len(self.derivnumlist)
		Summary_string = '\n\t' + str(len(self.propdict)) + ' numbered propositions\n'
		if n_defs > 0:
			Summary_string = Summary_string + '\t\t' + str(n_defs) + ' definitions\n' 
		Summary_string = Summary_string + '\t\t' + str(n_proofs) + ' proofs\n' 
		if n_unproved > 0:
			Summary_string = Summary_string + '\t\t' + str(n_unproved) +\
											' propositions given without proof\n' 
		if len(self.infruledict) > 0:
				Summary_string = Summary_string + \
				     '\n\t' + str(len(self.infruledict)) + ' rules of inference\n'
				Summary_string = Summary_string + \
				     '\t\t' + str(len(self.derivnumlist)) + ' derivations\n'
				Summary_string = Summary_string + \
				     '\t\t' + str(len(self.infruledict)-len(self.derivnumlist)) + ' rules stated without derivation\n'

		return Summary_string 

	def parse_all(self,mathonly):
		indexlist = build_indexlist(self.blocklist)
		#
		# Uses these states:
		#
		IN_TEXT  = 1    #   1.  In text (arrows to 2 and 3).

		GOT_PROP = 2    #   2.  Proposition received, expecting proof 
		                #       (arrows to 2, 3, and 4).
		GOT_INFRULE = 3 #   3.  Inference rule received, expecting derivation 
		                #       (arrows to 2, 4, and 5).
		GOT_PROOF_NOTE = 4 #4.  Proof note received, expecting another note 
		                #       (arrows to 3 and 1).
		GOT_DERIV_NOTE = 5 #5.  Derivation note received, expecting another note 
		                #       (arrows to 5 and 1).
		
		# State may change only at the beginning of a new line.
		
		state = IN_TEXT
		line_number = 0
		notelist = []
		notenumlist = []
		while  line_number < len(self.linelist):
			s = self.linelist[line_number]
			directivem = pattern.directive.match(s)
			if directivem:
				p = synt.process_directive(s)
				if type(p) is str:
					print("Error line: ", line_number + 1) 
					raise SystemExit(p)
				line_number = line_number + 1
				continue
				
#			block_number, string_index = self.indexlist[line_number]
			block_number, string_index = indexlist[line_number]
			blockaddress = [block_number, string_index]
			if not mathonly:
				#Test for change of state
				byem = pattern.bye.match(s)
				infrulem = pattern.inference_rule.match(s)
				notem = pattern.note.match(s)
				propnumm = pattern.propnum.match(s)
				if byem:
					if state == IN_TEXT or state == GOT_PROP or state == GOT_INFRULE:
						print("Error line: ", line_number + 1, 
									"No proof here to terminate.")
						raise SystemExit
					elif state == GOT_PROOF_NOTE:
						state = IN_TEXT
						line_number = line_number + 1
						raw_ref = self.getby(blockaddress)  
						parsed_proposition = self.propdict[state2_ref][2] # getformula()[2]
						wpt = parsed_proposition
						bye_note = Note()
						bye_note.single_line = True
						bye_note.varlist = synt.varlist(wpt)
						bye_note.parsed_item = wpt
						bye_note.text_fragments = [self.propdict[state2_ref][0]] # getformula()[0]
						bye_note.raw_justification = bystrip(raw_ref)
						srefp = synt.refparse(bye_note.raw_justification)
						if type(srefp) is str:
								bye_note.parsed_reference = []
								bye_note.error_message = srefp
						else:
							bye_note.parsed_reference = srefp
						notelist.append(bye_note)
						proof = Proof(state2_ref, prop_linenum, notelist, notenumlist)
						self.proofdict[state2_ref] = proof
						self.fullproofnumlist.append(state2_ref)
						self.proofnumlist.append(state2_ref)
						notelist = []
						notenumlist = []
						continue
					elif state == GOT_DERIV_NOTE:
						state = IN_TEXT
						line_number = line_number + 1
						raw_ref = self.getby(blockaddress)  
						raw_rule = self.infruledict[infrule_linenum]
						bye_note = Note()
						bye_note.text_fragments = [raw_rule] #
						bye_note.single_line = True
						bye_note.varlist = [] 
						sp = prop.shallowparse(raw_rule) 
						if sp == 0:
							raise SystemExit("Rule at line " + str(infrule_linenum) + "doesn't parse")
						bye_note.parsed_item = sp
						bye_note.raw_justification = bystrip(raw_ref)
						srefp = synt.refparse(bye_note.raw_justification)
						if type(srefp) is str:
							raise SystemExit("Rule at line " + str(infrule_linenum) + "doesn't parse")
						bye_note.parsed_reference = srefp
						notelist.append(bye_note)
						proof = Proof(state4_ref, infrule_linenum, notelist, notenumlist)
						if 'H' in raw_rule:
							proof.deductionrule = True
						self.proofdict[state4_ref] = proof
						self.derivnumlist.append(state4_ref)
						self.proofnumlist.append(state4_ref)
						notelist = []
						notenumlist = []
						continue
				elif infrulem:
					if state == IN_TEXT or state == GOT_PROP :
						state = GOT_INFRULE
					elif state == GOT_PROOF_NOTE:
						print("Error line: ", line_number + 1, 
										"Inference rule not allowed in a proof.")
						raise SystemExit
					elif state == GOT_INFRULE:
						pass
					elif state == GOT_DERIV_NOTE:
						print("Error line: ", line_number + 1, 
									"Inference rule not allowed in a derivation.")
						raise SystemExit
					line_number = line_number + 1
					infrule_linenum = line_number
					self.infruledict[infrule_linenum] = s
					state4_ref  = str(line_number)
					continue
				elif notem:
					if state == IN_TEXT :
						print("Error: ", line_number + 1, 
									"No theorem here to prove.")
						raise SystemExit
					elif state == GOT_PROP :
						state = GOT_PROOF_NOTE
					elif  state == GOT_INFRULE:
						state = GOT_DERIV_NOTE
					note_ref =  '.' + notem.group(1)
					if note_ref in notenumlist:
						print("Repeated note number", note_ref)
						print("Line: ", line_number + 1)
						raise SystemExit
					else:
						notenumlist.append(note_ref)
					blockaddress[0] = blockaddress[0] + 1
					linelist, parsed_note = self.getnotelines(blockaddress)
					if type(parsed_note) is str:
						error_message = "Error in multi-line note, line: " + \
						                 str(blockaddress[0] + 1)
						raise SystemExit(error_message)
					blockaddress[0] = blockaddress[0] + 1
					blockaddress[1] = 0
					raw_ref = self.getby(blockaddress)
					linelist[-1][-1] = bystrip(raw_ref)
					y = self.make_note(linelist, parsed_note)
					notelist.append(y)
				elif propnumm:
					state2_ref = propnumm.group('refnum')
					prop_linenum = line_number
					if state == IN_TEXT or state == GOT_INFRULE :
						state = GOT_PROP
					elif state == GOT_PROP:
						pass
					elif state == GOT_PROOF_NOTE:
						print("Error line: ", line_number + 1, 
									"Theorem not allowed in a proof.")
						raise SystemExit
					elif state == GOT_DERIV_NOTE:
						print("Error line: ", line_number + 1, 
									"Therem not allowed in a derivation.")
						raise SystemExit
					block_number = block_number + 1
					blockaddress[0] = block_number
					blockaddress[1] = 0
					y = self.getformula(blockaddress)
					blockaddress[0] = blockaddress[0] + 1
					blockaddress[1] = 0
					state2_ref = propnumm.group('refnum')
					if state2_ref in self.propdict:
						print("Duplicate proposition number: ", state2_ref)
						raise SystemExit
					self.propdict[state2_ref] = y
					raw_ref = self.getby(blockaddress)
					if propnumm.group(1)=='propd' or "\\By" in raw_ref and 'D'in raw_ref:
						if y[2][0][0] == 51:
								self.new_defnumlist.append(state2_ref)
						else:
								self.old_defnumlist.append(state2_ref)
						state = IN_TEXT
					elif propnumm.group(1)=='propa' or "\\By" in raw_ref and 'A'in raw_ref:
						self.axiomnumlist.append(state2_ref)
						state = IN_TEXT
					elif "\\By" in raw_ref:
						by_spot = raw_ref.index("\\By")
						proof = Proof(state2_ref, prop_linenum, raw_ref[by_spot+3:].lstrip(), [])
						self.proofdict[state2_ref] = proof
						outfilerefm = pattern.outfileref
						for r in proof.parsed_reference:
							if r[0] == '0':
								proof.basic_refnums.add(r)
							elif outfilerefm.match(r):
								proof.basic_refnums.add(r)
							elif r[0].isdigit():
								proof.prop_refnums.add(r)
						notelist = []
						notenumlist = []
						self.shortproofnumlist.append(state2_ref)
						self.proofnumlist.append(state2_ref)
						state = IN_TEXT
			
			block_number = blockaddress[0]
			string_index = blockaddress[1]
			x = self.blocklist[block_number][string_index]
			line_number = x[1] 
			last_line_number = line_number 
			
			while line_number == last_line_number:
				block = self.blocklist[block_number]
				while string_index < len(block):	  #Text block
					#pointedstring = (string, line_number, line_index)
					pointedstring = block[string_index]
					line_number = pointedstring[1]
					if line_number > last_line_number:
						break
					if pointedstring[0].startswith('%') or '\\noparse' in pointedstring[0]:
						line_number = line_number + 1
						break
					string_index = string_index + 1
				else:                             #Math block
					assert block_number % 2 == 0 , str(block_number)
					block_number = block_number + 1
					if block_number == len(self.blocklist):
						line_number = len(self.linelist)
						break
					blockaddress = [block_number , 0]
					y = self.getformula(blockaddress,just_one = False)
					x = self.blocklist[blockaddress[0]]	
					#Check that entire block was parsed.
					block_number = blockaddress[0]
					x = self.blocklist[block_number][-1]
					line_number = x[1] 
					last_line_number = line_number 
					block_number = block_number + 1
					string_index = 0
	

	def getformula(self, blockaddress, just_one = True):
		blocknumber = blockaddress[0]
#		stringindex = blockaddress[1]
		tree = []
		fetched_tf = ''
#
#  Brace initialization
#
		synt.bracestack = []
		synt.braceprefix = ''
		synt.current_fontmods = frozenset([])
		synt.current_fontnum = 0
		synt.fontmoddict = {}
#
#
		while True:

			mode = [2]
			mathlist = self.blocklist[blocknumber][1:-1]
			for i, x in enumerate(mathlist): 
					linetail = [x[0],0]
					if not pattern.token.match(x[0]):
						continue
					synt.mathparse(mode,linetail,tree, just_one)
					fetched_tf = fetched_tf + x[0]
					if mode[0] == 4:
							print(linetail)
							print("Error line ", x[1] + 1)
							raise SystemExit
					elif mode[0] == 5 :
						break
						pass
						blockaddress[0] = blocknumber
						blockaddress[1] = 0
						if tree[0][0][0] in [10,11]:
							return[fetched_tf,linetail[0],tree[0][1]]
						return [fetched_tf,linetail[0],tree[0]]
					if mode[0] == 4:
							print("Error line ", x[1] + 1)
							raise SystemExit
#					if mode[0] == 2:
#							assert False
#					fetched_tf = fetched_tf + x[0]
#					if not linetail[0]:
#						continue
#					if tree and all([x[0][0] > 0 for x in tree]):  # If the parse is done
#					print("tree ==============", tree)
					if tree and tree[-1][0][0] < 0:
						pass
					elif just_one or i + 1 == len(mathlist):
							break
					else:
							pass
#							mode[0] = 2

			else:
				blocknumber = blocknumber + 1
				self.margin_parse(blocknumber)
				blocknumber = blocknumber + 1
				continue

			if i + 1 == len(mathlist):
				blockaddress[0] = blocknumber
				blockaddress[1] = 0

				if not tree:
					return True
				if tree[0][0][0] in [10,11]:
					return[fetched_tf,linetail[0],tree[0][1]]
				return [fetched_tf,linetail[0],tree[0]]
			else:
				print(x[0][:linetail[1]])
				print(mathlist)
				print("Error line ", x[1] + 1,
							"Formula completed before the end of math mode.")
				raise SystemExit

	def margin_parse(self, blocknumber):
			raw_reflist = [x[0] for x in self.blocklist[blocknumber] \
											if not x[0].startswith('%')]
			num_endlines = len([x for x in raw_reflist \
											if x.endswith('\n')])

			if num_endlines == 0:
					if pattern.hwhite.match("".join(raw_reflist)):
						return
					else:
						print("Error line ", self.blocklist[blocknumber][0][1] + 1,
								"White space only here")
						raise SystemExit

#			if self.blocklist[blocknumber][0][0].strip() == '\\suspend':
			if self.blocklist[blocknumber][0][0].lstrip().startswith('\\suspend'):
					return
			
			for i, x in enumerate(raw_reflist):
				if x.endswith('\n'):
						index_last_endline = i
						
			raw_ref = ''
			tail = ''
			for i,x in enumerate(raw_reflist):
				if i < index_last_endline:
					if x.endswith('\n'):
						if x.endswith('\\\n'):
							extend_spot = x.index('\\\n')
							raw_ref = raw_ref + x[:extend_spot]
						else:
							print("raw_reflist ====", raw_reflist)
							print("Extension mark needed on line:",
												self.blocklist[blocknumber][i][1] +1)
							print("Previous block ====", self.blocklist[blocknumber -1])
							raise SystemExit
					else:
						raw_ref = raw_ref + x
				elif i == index_last_endline:
					raw_ref = raw_ref + x.rstrip()
				else:
					tail = tail + x

			if raw_ref.strip() == '':
				pass
			elif raw_ref.lstrip().startswith("\\By"):
				by_spot = raw_ref.index("\\By")
				raw_ref = raw_ref[by_spot + 3:]
			else:
				print("Error line:", self.blocklist[blocknumber][i][1] +1)
				print("Margin interior to formula contains: ", raw_ref.lstrip())
				raise SystemExit

			if pattern.leftmargin.match(tail):
				pass	
			else:
				print("Bad left margin.")
				raise SystemExit
			return raw_ref.strip()

	def getby(self, blockaddress):
			raw_ref = ''
			blocknumber = blockaddress[0]
			string_index = blockaddress[1]
			block = self.blocklist[blocknumber]
			grace_period_available = True 
			while string_index < len(block):
				x = block[string_index][0]
				if x.startswith('%'):
					pass
				elif x.endswith('\\\n'):
					extend_spot = x.index('\\\n')
					raw_ref = raw_ref + x[:extend_spot]
				elif x.endswith('\n') and grace_period_available:
					raw_ref = raw_ref + x
					# Look ahead
					if "\\By" not in raw_ref and string_index + 1 != len(block):
						y = block[string_index + 1][0]
						if not ("\\Bye" in y or "\\note" in y or "\\prop" in y):
									grace_period_available = False
						else:
								blockaddress[1] = string_index
								break
					else:
								blockaddress[1] = string_index
								break
				elif x.endswith('\n'):
					raw_ref = raw_ref + x
					blockaddress[1] = string_index
					break
				string_index = string_index + 1
			else:
				# This restriction may not be necessary.  It triggers
				# if math mode is resumed without encountering either 
				# the \By which was sought or an end of line.
				# 
				if grace_period_available:
					print("Line number: ", self.blocklist[blocknumber + 1][0][1]) 
					print("Error: Proposition or note needs an end of line.")
					raise SystemExit("'By' expected, math belongs on the next line.")
			return raw_ref



	def make_note(self, linelist, mathparsed_note):
		if not linelist:
			return []

#		mathparsed_note = linelist.pop()

		if mathparsed_note[0][0] in [10,11]:
			mathparsed_note = mathparsed_note[1]

		steplist = [[[]]]
		tempref = ''
		for t in linelist:
			if t[0] :
				steplist[-1].append(tempref)
				tempref = t.pop()
				steplist.append(t)
			else:
				if tempref:
					print("Stranded reference:", tempref)
					print("Missing transitive declaration needed:", t[1], "?")
				tempref = t.pop()
				steplist[-1].append(t[1])
		steplist[-1].append(tempref)
	
		if len(steplist) == 1:
			textfragments = steplist[0][1:-1]
			this_ref = steplist[0][-1]
			single = Note()
			single.single_line = True
			single.varlist = synt.varlist(mathparsed_note)
			single.parsed_item = mathparsed_note
			single.textfragments = steplist[0][1:-1]
			single.raw_justification = bystrip(this_ref)
			srefp = synt.refparse(this_ref)
			if type(srefp) is str:
				single.parsed_reference = [] 
				single.error_message = srefp
			else:
				single.parsed_reference = srefp 
			return single
			return [1, synt.varlist(mathparsed_note), mathparsed_note, textfragments, this_ref]
	
		multi_line = Note()
		multi_line.single_line = False
		multi_line.chain = buildchain(steplist)
		multi_line.parsed_item = mathparsed_note
		multi_line.varlist = synt.varlist(mathparsed_note)
		if multi_line.chain == []:
			print("Note multi-line note error" , linetail[0])
			print(linetail[2])
			return 0
		return multi_line 

# The following function returns a pair.
# If the second element is a string then it is
# an error message; otherwise it is the mathparse of the note.
# The first element of the pair is the list of all triples
# [number, fetched note text, fetched reference text]
# The number is positive if a transitive parse
# is indicated. 

	def getnotelines(self,blockaddress):
		blocknumber = blockaddress[0]
		stringindex = blockaddress[1]
		precedence = synt.mathdb[synt.MD_PRECED]
		tree = []
		linelist = []
		lenstepconnector = -1
		thisref = ''

		while True:

			mode = [2]
			mathlist = self.blocklist[blocknumber][1:-1]
			for i, x in enumerate(mathlist): 
					tokenm = pattern.token.match(x[0].lstrip())
					if not tokenm:
						continue
					token = tokenm.group(2)
					newtag = optag(x[0].lstrip(), tree)
#					assert newtag == [] or newtag[-1] == token , newtag[-1] + " != " + token
					if newtag:
						token = newtag[-1]
					if lenstepconnector != -1:
						linelist.append([lenstepconnector, newstuff, thisref])
					thisref = ''
					newstuff = x[0].lstrip()
					if newtag == []:
							lenstepconnector = []
					elif tree == []:
							error_message = "Error in multi-line note"
							blockaddress[0] = x[1]
							blockaddress[1] = x[2]
							return [linelist, error_message]
					elif opcoords(tree,precedence[token]) == (0,0):
							lenstepconnector = []
					else:
							lenstepconnector = newtag
					linetail = [newstuff,0]
					synt.mathparse(mode, [newstuff],tree, just_one= True)
					if mode[0] == 4:
							error_message = "Note does not parse"
							blockaddress[0] = x[1]
							blockaddress[1] = x[2]
							return [linelist, error_message]
					if tree and tree[0][0][0] > 0 :   # If the parse is done
							break

			else:
				blocknumber = blocknumber + 1
#				print("last block ======", self.blocklist[blocknumber-1])
#				print("this block ======", self.blocklist[blocknumber])
#				print("tree[-1] ========", tree[-1])
				thisref = self.margin_parse(blocknumber)
				blocknumber = blocknumber + 1
				continue

			if i + 1 == len(mathlist):
				blockaddress[0] = blocknumber
				blockaddress[1] = 0
				linelist.append([lenstepconnector, newstuff, thisref])
				return (linelist, tree[0])
				parsed_item = tree[0]
				linelist.append(parsed_item)
				return linelist

			else:
				print(x[0][:linetail[1]])
				print(mathlist)
				print("Error")
				raise SystemExit


#def optag(line,node):
#	precedence = synt.mathdb[synt.MD_PRECED]
#	userdict = synt.mathdb[synt.MD_MACR]
#	original_len = len(line)
#	tokenm = pattern.token.match(line)
#	token = tokenm.group(2)
#	user_token_len = len(token)
#	token_root = userdict.get(token,token)
#	tokens = []
#	precedence_list = []
#	while synt.symtype(token_root) < 4:
#		precedence_list.append(precedence[token_root])
#		if precedence[token_root] != precedence_list[0]:
#			break
#		tokens.append(token_root)
#		nexttokenlen = len(token)
#		line = line[nexttokenlen:]
#		line = line.lstrip()
#		tokenm = pattern.token.match(line)
#		if tokenm:
#			token = tokenm.group(2)
#			token_root = userdict.get(token,token)
#		else:
#			break
#	if len(tokens)== 0:
#		return []
#	minimum_precedence = min(precedence_list)
#	if minimum_precedence not in [2,4,6]:
#		return []
#	if len(tokens) == 1 :
#		return [user_token_len,len(node),minimum_precedence,tokens[0]]
#	elif len(tokens) > 1:
#		print(tokens)
#		return [original_len -len(line),len(node),minimum_precedence,tuple(tokens)]

def optag(line,node):
	precedence = synt.mathdb[synt.MD_PRECED]
	tr_precedences = synt.mathdb[synt.MD_TRPRS]
	tokenlist = []
	len_optag = synt.fetch_tokenlist(line, 0, tokenlist)
	token = ' '.join(tokenlist)
	if precedence.get(token) not in tr_precedences:
		return []
	return [len_optag,len(node),precedence[token],token]

def buildchain(steplist):
	firstline =  ' '.join(steplist[0][1:-1])
	treesg = []
	mode = [2]
	synt.mathparse(mode,[firstline],treesg)
	link0 = Link()
	link0.delta_goal = parenclose(treesg)
	link0.sigma_goals = []
	link0.textfragments = steplist[0][1:-1]
	link0.raw_justification = bystrip(steplist[0][-1])
	srefp = synt.refparse(link0.raw_justification)
	if type(srefp) is str:
		link0.parsed_reference = [] 
		link0.error_message = srefp
	else:
		link0.parsed_reference = srefp
	chain = [link0]
#	chain = [[parenclose(treesg),[],steplist[0][1:-1], steplist[0][-1]]]
	stack = [[copy.deepcopy(treesg), 0, 0]]
	treedl = copy.deepcopy(treesg)
	num_steps = len(steplist)
	steplist.append([[0,0,0,'']])
	for k in range(1,num_steps):
		tran_tag = steplist[k][0]	
#		print("tran_tag =======", tran_tag)
		next_tran_tag = steplist[k+1][0]	
		(dpth,prcd) = [tran_tag[1], tran_tag[2]] 
		(next_dpth, next_prcd) = [next_tran_tag[1], next_tran_tag[2]]
		op = tran_tag[3]
#		print("op1 =============", op)
		oplen = tran_tag[0]
		op = steplist[k][1][:oplen]
#		print("op2 =============", op)
		finish = steplist[k][1][oplen:] + ' ' + ' '.join(steplist[k][2:-1])
		if type(op) is not str: 
			pass
		synt.mathparse(mode,[op],treesg)
		synt.mathparse(mode,[op],treedl)
		deltadelete(treedl,prcd)
		ok = sigmarevise(treesg,prcd)
		if ok == 0:
			return []
		depth = len(treedl)
		splitlist = finish.split(')')
		len_splitlist = len(splitlist)
		j = 0
		synt.mathparse(mode,[splitlist[j]],treedl)
		synt.mathparse(mode,[splitlist[j]],treesg)
		while j + 1 < len_splitlist and len(treedl) > depth:
			j = j + 1
			synt.mathparse(mode,[')' + splitlist[j]],treedl)
			synt.mathparse(mode,[')' + splitlist[j]],treesg)
		if j + 1 < len_splitlist:
			splitlist = splitlist[j+1:]
		else:
			splitlist = []

		pr = treesg	
		qr = treedl
		pq = pr
		link = [parenclose(treedl),[], steplist[k][1:-1],steplist[k][-1]]
		link = Link()
		link.delta_goal = parenclose(treedl)
		link.sigma_goals = []
		link.textfragments = steplist[k][1:-1]
		link.raw_justification = bystrip(steplist[k][-1])
		srefp = synt.refparse(link.raw_justification)
		if type(srefp) is str:
				link.parsed_reference = []
				link.error_message = srefp
		else:
				link.parsed_reference = srefp
		chain.append(link)
		
		while (dpth, prcd)  >=  (next_dpth, next_prcd):
			old_dpth = dpth
			old_prcd = prcd
			if not stack:
				break
			[last_treesg, dpth, prcd] = stack.pop()
			qr = copy.deepcopy(treedl)
			pq = copy.deepcopy(last_treesg)
			(op_spot, op_len) = opcoords(pr,old_prcd)
			
			if (op_spot,op_len) == (0,0):
				break	
			op = pr[-1][op_spot:op_spot + op_len]
			finish = pr[-1][op_spot + op_len:]
			tail_prcd= pr[-1][0][1] 

			synt.paradecrop(last_treesg[-1], old_prcd)
			last_treesg[-1].extend(op)
			pr = copy.deepcopy(last_treesg)
			sigmarevise(pr,old_prcd)
			pr[-1].extend(finish)
			pr[-1][0][1] = tail_prcd
			if old_dpth > next_dpth:
				while len(pr) >= next_dpth > 0 and len(pr) > 1 and len(splitlist) > 0:
					synt.mathparse(mode,[')' + splitlist[0]], pr)
					synt.mathparse(mode,[')' + splitlist[0]], treesg)
					splitlist = splitlist[1:]
				
			link.sigma_goals.append([parenclose(pr),parenclose(pq),parenclose(qr)])
			treedl = pr

		if splitlist:
			close_off = ')' + ')'.join(splitlist)
			synt.mathparse(mode,[close_off],treedl)
			synt.mathparse(mode,[close_off],treesg)
		stack.append([copy.deepcopy(treedl),dpth, prcd])
	return chain

def parenclose(parsetree):
	copy_tree = copy.deepcopy(parsetree)
	mode = [2]
	while mode[0] ==2 and copy_tree[-1][0][0] < 0:
		synt.mathparse(mode,[')'],copy_tree)
	if mode[0] == 4:
		return []
	return copy_tree[0]

	
def deltadelete(tree,precedence):
	node = tree[-1]
	(index, length) = opcoords(tree,precedence)
	for n in range(length+1):
		del node[index-1]
	return 

def sigmarevise(tree,precedence):
	node = tree[-1]
	(index, length) = opcoords(tree,precedence)
	if length == 1:
		nexusop = node[index][1]
#	else:
#		assert False
#		nexus_list = []
#		for i in range(length):
#			nexus_list.append(node[index + i][1])
#		nexusop = tuple(nexus_list)
	resultop=transopswap(nexusop,node[index+length+1][1])
	if resultop == 0 :
		pass
	else:
		node[-1][1] = resultop
		assert type(resultop) is str 
#	else:
#		assert False
#		resultnodes = []
#		for op in resultop:
#			resultnodes.append([node[-1][0], op ,node[-1][2]])
#		node[-1:] = resultnodes
	for n in range(length+1):
		del node[index]
	return

def opcoords(parsetree,precedence ):
	node = parsetree[-1]
#	precedence = node[0][1]

	i = len(node) -1
	while  i > 0 :
		i = i - 1
		if opnodep(node[i],precedence) and\
		not(i > 0 and opnodep(node[i-1],precedence)): 
			break
	if i == 0:
		return (0,0)
	k = 1
	while   i + k  < len(node) and opnodep(node[i + k],precedence) :
		k = k + 1 
	return (i,k)

def opnodep(node,precedence): 
	return (type(node) is list and type(node[0]) is list and 
   node[0][0] < 4 and node[2]== precedence) 

def transopswap(op1, op2):
	ident_ops = synt.mathdb[synt.MD_IDOPS]
	trans_mult = synt.mathdb[synt.MD_TRMUL]
	precedence = synt.mathdb[synt.MD_PRECED]
	if (op1,op2) in trans_mult:
		return trans_mult[(op1,op2)]
	if op1 in ident_ops:
		return op2
	if op2 in ident_ops:
		return op1
	return 0

def build_blocklist(linelist):
		"""
  The length of blocklist is odd unless the last
  math mode fails to terminate.  Elements with
  even index are text. Elements with odd index are math.
  Comment strings are elements of a block whose initial 
  symbol is a percent sign.  Every block contains at
  least one string, which may be the empty string. """
			
		begin = pattern.beginmath_or_comment
		end   = pattern.endmath_or_comment

		state = 1  # reading text
		#     = 2    reading math

		block = []
		blocklist = []

		k = 0  # line number
		j = 0  # character number
		r = linelist[k]

		while r:
			if state == 1:
				begins = begin.search(r)
				if not begins:
					block.append((r,k,j))
					r = ''
				elif begins.group(1) == '%':
					block.append((r[:begins.start(1)],k,j))
					j = j + begins.start(1)
					block.append((r[begins.start(1):],k,j))
					r = ''
				else:
					block.append((r[:begins.start(1)],k,j))
					blocklist.append(block)
					j = j + begins.start(1)
					block = [(begins.group(1),k,j)]
					r = r[begins.end(1):]
					j = j + len(begins.group(1))
					state = 2
			elif state == 2:
				ends = end.search(r)
				if not ends:
					block.append((r,k,j))
					r = ''
				elif ends.group(1) == '%':
					block.append((r[:ends.start(1)],k,j))
					j = j + ends.start(1)
					block.append((r[ends.start(1):],k,j))
					r = ''
				else:
					block.append((r[:ends.start(1)],k,j))
					j = j + ends.start(1)
#					if block[0][1] < block[-1][1]:
#						for b in blocklist[::-2]:
#							for y in b[::-1]:
#								if y[1] < block[0][1]:
#									break
#								elif '\\noparse' in y[0]:
#									raise SystemExit("Line "+ str(k) +": noparse macro hits line break!")
#							else:
#								continue
#							break

#						for y in blocklist[-1]:
#							if y[1] == block[0][1]:
#								if '\\noparse' in y[0]:
#									print
#									raise SystemExit("Line "+ str(k) +": noparse macro hits line break!")
					block.append((ends.group(1),k,j))
					blocklist.append(block)
					block = []
					r = r[ends.end(1):]
					j = j + len(ends.group(1))
					state = 1
			if r == '':
				if k + 1 < len(linelist):
					k = k + 1
					r = linelist[k]
					j = 0
				else:
					if block:
						blocklist.append(block)
					return blocklist
			

def build_indexlist(blocklist):
		"""
Returns a list whose k-th element is the pair
(block_number, string_index) of the beginning
of the k-th line of the file."""

		address_list = []
		k = 0
		for i, block in enumerate(blocklist):
			for j,pair in enumerate(block): 
#				if pair in block and pair[1] == k: 
				if pair[1] == k: 
					address_list.append((i,j))
					k = k + 1
		return address_list


def bystrip(bystring):
			bye_spot = bystring.find("\\Bye")
			by_spot = bystring.find("\\By")
			if bye_spot > -1:
				return bystring[bye_spot + 4:].strip()
			elif by_spot > -1:
				return bystring[by_spot + 3:].strip()
			else:
				return bystring.strip()

class Proof:
	def __init__(self, ref, linenum, notelist, numlist):
		assert type(ref) is str
		self.ref = ref
		self.linenum = linenum 
		self.prop_refnums = set()
		self.basic_refnums = set()
		self.note_refnums = set()
		self.deductionrule = False
		outfilerefm = pattern.outfileref
		if type(notelist) is str:
			self.shortproof = True
			self.notelist = []
			self.raw_justification = notelist
			self.parsed_reference = synt.refparse(notelist)
#			assert type(self.parsed_reference) is list:
			for r in self.parsed_reference:
				if r[0] == '0': 
					self.basic_refnums.add(r)
				elif outfilerefm.match(r):
					self.basic_refnums.add(r)
				elif r[0].isdigit():
					self.prop_refnums.add(r)
		else:
			self.shortproof = False 
			self.notelist = notelist 

			for note in notelist:
				if note.single_line:
					for r in note.parsed_reference:
						if r[0] == '0': 
							self.basic_refnums.add(r)
						elif outfilerefm.match(r):
							self.basic_refnums.add(r)
						elif r[0].isdigit():
							self.prop_refnums.add(r)
						elif r[0] == '.':
							self.note_refnums.add(r)
				else:
					for link in note.chain:
						for r in link.parsed_reference:
							if r[0] == '0': 
								self.basic_refnums.add(r)
							elif outfilerefm.match(r):
								self.basic_refnums.add(r)
							elif r[0].isdigit():
								self.prop_refnums.add(r)
							elif r[0] == '.':
								self.note_refnums.add(r)
	
		self.nums_are_consecutive = True
		self.numlist = numlist
		self.note_num_consec = {}
		c = 0
		for t in self.numlist:
			c = c + 1
			self.note_num_consec[t] = c
			if int(t[1:]) != c:
				self.nums_are_consecutive = False
			
		self.unused_notes = [x for x in numlist if not x in self.note_refnums]
	#
	# Attributes used only in checking.
	#
		self.note_reflist = []
		self.given_vars = {}
		self.given_vars[0] = [[],[]]
		self.given_varlist = ['placeholder']
		self.given_numlist = ['placeholder']
		self.used_notes = []
		self.global_givens = []   # Should change this name
		self.outstanding_givens = []
		self.propflags = {}
	
	def __str__(self):
		retstring ="Proof of " + self.ref + '\n'
		retstring = retstring + "Basic refnums = " + str(self.basic_refnums)
		for note in self.notelist:
			retstring = retstring + str(note) + '\n'
		return retstring

	def checknoterefs(self, c, parsed_reference, current_givennums):
#		parsed_reference = note.parsed_reference
		for x in parsed_reference:
			if x[0] == '.':
				y = self.note_num_consec.get(x, -1)
				if y == -1:
						return "No such note as " + x
#				if x in inrnum.keys():
				elif y == c:
						return "Note may not refer to itself."
				elif not(y < c): 
						return "Reference to later note "  + x + " not valid."
				else:
					for z in self.given_numlist[y]:
						if z not in current_givennums:
							return x + " assumes given, " + str(z) + ", which is no longer valid."
		return ''
	
class Note: 
				
	def __init__(self):
		self.single_line = True     #[0]
		self.chain = []
		self.varlist = []           #[1]
		self.parsed_item = []       #[2]
		self.textfragments = []     #[3]
		self.raw_justification = '' #[4]
		self.parsed_reference = []  #[5]
		self.error_message = ''     #[6]

	def __str__(self):
		return \
		"Text =  " + " ".join(self.textfragments)  + "\n" + \
		"By   =  " + self.raw_justification

class Link:
	def __init__(self):
		self.delta_goal = []        #[0]
		self.sigma_goals = []       #[1]
		self.textfragments = []     #[2]
		self.raw_justification = '' #[3]
		self.parsed_reference = []  #[4]
		self.error_message = ''     #[5]
		self.parsed_item = []

