import pattern, synt, copy

propflags = {2:3}

def cmop(form):
	global propflags
	if type(form) is not list: return ''
	if len(form) < 3: return ''
	if type(form[2]) is not str: return ''
#	prop_flag = synt.mathdb[synt.MD_NRYPROP].get(form[2]) 
	prop_flag = propflags.get(form[2]) 
	if not prop_flag : return ''
	if prop_flag & 24 == 24:
		return form[2]
	return ''

#def negdeep(exp):
#	print("negdeep: exp ==============", exp)
#	newexp = deep(exp)
#	if type(newexp) is str: 
#		return newexp
#	elif len(newexp) == 4 and newexp[2] == '\\c' and newexp[1] == '\\true':
#		return negdeep(newexp[3])
#	if len(newexp) == 4 and newexp[2] == '\\c' and newexp[3] == '\\false':
#		if type(newexp[1]) is list and len(newexp[1])== 3 and newexp[1][1] == '\\Not':
##			return newexp[1][2]
#		else:
#			return [[41, [0]],'\\Not', newexp[1]] 
#	else:
#		return newexp

def deep(exp):
	cmopp = cmop(exp)
	if type(exp) is str: 
		return exp
	elif exp[1] == '(':
		return deep(exp[2])
	elif exp[0][0] in [14,15]:
		return exp[1]
	elif cmopp:
		retlist = [exp[0]]
		for r in exp[1:]:
			d = deep(r)
			if cmop(d) == cmopp:
				retlist.extend(d[1:])
			else:
				retlist.append(d)
		return retlist
#	elif exp[0][0] == 45 and exp[0][1] == 6:  precedence level is exp[0][1]
	elif exp[0][0] == 45 and exp[0][1] in synt.mathdb[synt.MD_CTHNDL]:
		handler = eval(synt.mathdb[synt.MD_CTHNDL][exp[0][1]])
		recurselist = [exp[0]]
		for r in exp[1:]:
			recurselist.append(deep(r))
#		return verbexpand(recurselist)
		return handler(recurselist) 
	elif len(exp[0]) > 1 and\
        exp[0][0] in [40,41] and\
        exp[0][1] in [3,4,5,6,7]:
 		return notariancondense(exp)
	else:
		retlist = [exp[0]]
		for x in exp[1:]:
			retlist.append(deep(x))
		return retlist
	
def verbexpand(pexp):
	assert type(pexp) is list and pexp[0][1] == 6, "verbexpand: " + str(pexp) 
	verblist = []
	termlist = []
	lastterm = []
	lastverb = []
	subjects = []
	conjunctlist = []
	for x in pexp[1:] + ['=']:
		if x == ',':
			if lastterm == lastverb == []:
				print("Initial commas and double commas not allowed")
				raise SystemExit 
			elif lastterm == []:
				verblist.append(lastverb) 
				lastverb = []
			elif lastverb == []:
				termlist.extend(lastterm)
				lastterm = []
		elif type(x) is list or synt.symtype(x) in[10,14]:
			if lastterm != []:
				raise RuntimeError("Parse failure")
			lastterm = [x]
			if lastverb != []:
				verblist.append(lastverb)
				modifiers = verblist
				lastverb = []
				verblist = []
			elif verblist != []:
				raise RuntimeError("Parse wrong")
		else:
			if lastverb == verblist == []:
				if lastterm != []:
					termlist.extend(lastterm)
					lastterm = []    # Here is the possible change!!!!!!!!!!!
				if len(termlist) == 1:
					objectofverb = termlist[0]
				else:
					objectofverb = [[44, 6]]
					for y in termlist:
						objectofverb.append(y)
						objectofverb.append(',')
					del objectofverb[-1]
				for s in subjects:
					clause = [[45,6]]
					clause.append(s)
					clause.extend(modifiers[-1])
					clause.append(objectofverb)
					conjunctlist.append(clause)
					for t in subjects:
						if t is s: break
						for r in modifiers[:-1]:
							clause = [[45,6]]
							clause.append(t)
							clause.extend(r)
							clause.append(s)
							conjunctlist.append(clause)
				if len(termlist) > 1 and lastterm == []:
					subjects = termlist
				else:
					subjects = [objectofverb]
#
#To accomodate Morse's tuple scheme uncomment this:		
#
#				if len(termlist) == 1 and lastterm == []:
#					lastverb.append(',')
#
				lastterm = []
				termlist = []
			lastverb.append(x)
	if verblist != [] or lastverb != ['=']:
		print("Mistake")
		raise SystemExit
	if len(conjunctlist)==1:
		return conjunctlist[0]
	else:
		retlist = [[45,synt.mathdb[synt.MD_PRECED]['\\And']] ,conjunctlist[0]]
		for x in conjunctlist[1:]:
			retlist.append('\\And')
			retlist.append(x)
		return retlist
	
#def workparse(strexp):
#	print("strexp ========", strexp)
#	parse_tree = []
#	mode = [2]
#	synt.mathparse(mode,[strexp],parse_tree)
#	print("parse_tree ======", parse_tree)
#	if mode[0] != 4:
#		return deep(parse_tree[0])
#	else:
#		return 0

def newvarlist(list):
	global synt 
# This is only called by notariancondense when some variable
# occurs in both indicial and accepted positions
	r = []	
	for x in list:
		synt.newvarnum = synt.newvarnum + 1
		r.append('v_{' + ("%d" % synt.newvarnum) + '}')
	return r

def notariancondense(pexp):
	styp = synt.symtype(pexp[1])
	ntyp = pexp[0][1]
	indvs = synt.indvlist(pexp)
	accvs = synt.accvlist(pexp)
	for x in indvs:
		if x in accvs:
			nlist = newvarlist(indvs)
			newform = synt.indvsubst(nlist, indvs, pexp)
			indvs = nlist
			break
	else:
		newform = copy.deepcopy(pexp)
	newscope = [[48,[]], indvs[0]]
	for x in indvs[1:]:
		newscope.append(',')
		newscope.append(x)
		
	for x in newform[1:]:
		if type(x) is str: 
			pass
		elif x[0][0] == 48:
			scopecond = scopecondition(x)
	if ntyp == 4:
		if scopecond:
			scopecond = makeand(scopecond, deep(newform[-1] ))
		else:
			scopecond = newform[-1]
	elif ntyp in [5,7]:
		if scopecond:
			scopecond = makeand(scopecond, deep(newform[-2])) 
		else:
			scopecond = newform[-2]
	if scopecond == []:
		if styp == 8 or ntyp in [6,7]:
			scopecond = '\\true'

	if ntyp in [3,5]:
		indform = newform[-1]
	elif ntyp == 4 :
		if len(indvs) == 1:
			indform = indvs[0]
		else: #We may never use this:
			indform = [[45,6]] + newscope[1:]
	else:
	 	indform = newform[2] 

	if ntyp in [6,7]and styp == 9:
		if ntyp == 7:
			newform[2] = deep(newform[2])
			newform[4] = newscope 
			newform[6] = deep(scopecond)
		elif ntyp == 6:
			newform[0][1] = 7
			newform[2] = deep(newform[2])
			newform[4] = newscope 
			newform[5:5] = [';',deep(scopecond)]
	elif styp == 8:
		newform[2:] = []
		newform[0][1] = 5
		newform.append(newscope)
		newform.append(';')
		newform.append(deep(scopecond))
		newform.append(deep(indform))
	else:
		newform[2:] = []
		newform[0][1] = 3
		indform = deep(indform)
		if newform[1]== '\\Each' :
			if ntyp == 4: 
				raise RuntimeError("Colon not expected")
			elif type(indform) is list and\
      indform[0] == [45,2] and\
      indform[2] == '\\c' and scopecond:
				indform[1] = makeand(deep(scopecond), indform[1])
			elif scopecond:
				indform = [[45,2],deep(scopecond), '\c', indform]
		elif scopecond:
			indform = makeand(deep(scopecond),indform)
		newform.append(newscope)
		newform.append(indform)

		if len(indvs) > 1 and newform[1] in['\\Each','\\Some']:
			indform = deep(newform[-1])
			singlequant = newform[:2]
			rindvs = indvs[:]
			rindvs.reverse() 
			for x in rindvs:
				newscope = [[48,[]], x]
				newform = singlequant + [newscope] 
				newform.append(indform)
				indform = newform
	return newform 

def makeand(exp1, exp2):
#	if '\\And' in mathdb[synt.MD_CAOPS]:
#		andback = [[45,5,-1]]
#	else:
#		andback = [[45,5]]	
	andback = [[45,synt.mathdb[synt.MD_PRECED]['\\And']]]
	if cmop(exp1) == '\\And':
		andback.extend(exp1[1:])
	else:
		andback.append(exp1)
	andback.append('\\And')
	if cmop(exp2) == '\\And':
		andback.extend(exp2[1:])
	else:
		andback.append(exp2)
	return andback

def scopecondition(scopenode):
	state = 0
	tree = []
	synt.addtoken(tree,'(')
	verbfound = 0
	for xi in scopenode[1:]:
		if type(xi) is list: 
			if state == 1:
				state = 2
			synt.addnode(tree,xi)
		elif synt.symtype(xi) == 14:
			if state == 1:
				state = 2
			synt.addtoken(tree,xi)
		elif synt.symtype(xi) == 10:
			if state == 0: 
				pass	
			elif state == 1:
				state = 2
			synt.addtoken(tree,xi)
		elif xi ==  ',':
			if state == 2:
				state = 0
				synt.addtoken(tree,'\\And')
			else:
				synt.addtoken(tree,xi)
		elif synt.symtype(xi) == 3:
			if state == 0:
				state = 1
				verbfound = 1
			synt.addtoken(tree,xi)
		else:
			raise RuntimeError("Scope error")
	if verbfound:
		synt.addtoken(tree,')')
		return tree[0][2]
	else:
		return []

def stringparse(wffstring):
	parsetree = []
	mode = [2]
	synt.mathparse(mode,[wffstring] ,parsetree)
	return parsetree[0]


def shallowparse(textline):
		rule = []
		rulesignature = []
		t = textline
		while t:
			t = t.lstrip()
			if not t: break
			if t[0] == '$':
				TeXmatch = pattern.TeXmath.match(t)
				if not TeXmatch:
					raise ValueError(" Unmatched Tex dollar sign")
					print("Error: Unmatched Tex dollar sign")
					return 0
				rvar = stringparse(TeXmatch.group(1))
				if rvar == 0:
					raise ValueError(" Bad rule: " + TeXmatch.group(1) + " in " + textline)
					print("Error: Bad rule", TeXmatch.group(1), "in", textline)
					return 0
				rule.append(rvar)
				rulesignature.append('$')
				t = TeXmatch.group(2)
				continue
			punctsmatch = pattern.puncts.match(t)
			puncts = punctsmatch.group(1)
			findsinglematch = pattern.findsingle.match(puncts)
			if findsinglematch:
				if findsinglematch.start(1) == 0:
					rulesignature.append(puncts[0])
					t = t[1:]
				elif findsinglematch.group(1) in synt.reference_punctuator_list: 
					rulesignature.append(findsinglematch.group(1))
					t = t[findsinglematch.start(2):]
				else:
					raise ValueError(findsinglematch.group(1) + " invalid punctuator")
			else:
				u = punctsmatch.group(2)
				if puncts in synt.reference_punctuator_list:
					rulesignature.append(puncts)
					t = u 
				else:
					raise ValueError(puncts + " invalid punctuator")
		assert len(rule) == rulesignature.count('$')
		return (rule, rulesignature)


############################################################
#
#  Get transitive properties from file and store in db
#
############################################################

def readprops(propfilename, entry, db):
	if len(db) < synt.MD_LEN:
			print("dfs file obsolete")
			raise SystemExit
	f = open(propfilename,"r")
	line_list = f.readlines()
	f.close()
	if len(entry) == 1:
		first_line = 1
		last_line = len(line_list)
	else:
		first_line = entry[1]
		last_line = entry[2] 
	for i, r in enumerate(line_list):
		if i < first_line - 1 or i >= last_line:
			continue
		infrulem = pattern.inference_rule.match(r)
		if not infrulem:
			continue
		infrule = Rule(r)
		if not infrule.signature == ['$', '-', '$', '\\C', '$']:
			continue
		xy_form = infrule.body[0]
		yz_form = infrule.body[2]
		xz_form = infrule.body[4]
		if not(xy_form[0][0] == yz_form[0][0] == xz_form[0][0] in [44,45]):
			continue
		if not(len(xy_form) == len(yz_form) == len(xz_form) == 4):
			continue
		if not all([type(x) is str for x in xy_form[1:]]):
			continue
		if not all([type(x) is str for x in yz_form[1:]]):
			continue
		if not all([type(x) is str for x in xz_form[1:]]):
			continue
		if xy_form[1] == xz_form[3] or xy_form[1] != xz_form[1] or yz_form[3] != xz_form[3]:
			continue
		db[synt.MD_TRMUL][(xy_form[2], yz_form[2])] = xz_form[2]
		if db[synt.MD_PRECED][xy_form[2]] not in db[synt.MD_TRPRS]:
			db[synt.MD_TRPRS].append(db[synt.MD_PRECED][xy_form[2]])
		if db[synt.MD_PRECED][yz_form[2]] not in db[synt.MD_TRPRS]:
			db[synt.MD_TRPRS].append(db[synt.MD_PRECED][yz_form[2]])
			

class Rule:

	def __init__(self,textline):
		shallow = shallowparse(textline)
		parsed_rule = shallow[0]
		#signature = shallow[1]
		body = []   #formerly rule[0]
		allvars = []   #formerly rule[1]
		signature = []  #formerly rule[2]

		i = 0
		for sig_element in shallow[1]:	
			signature.append(sig_element)
			if sig_element == '$':
				d = deep(parsed_rule[i])
				i = i + 1
				if type(d) is list and d[0][0] in [10,11]:
					body.append(d[1])
				else:
					body.append(d)
				for x in synt.varlist(d):
					if x not in allvars:
						allvars.append(x)
			else:
				body.append(sig_element)

		self.body = body
		self.allvars = allvars
		self.signature = signature
		self.filename = ''
		self.linenum = 0
		self.tracefun = ''



	def premise_list(self): 
		return self.body[:self.body.index('\\C')]

