#
# Thanks to Anthon Van der Neut for this "recipe"
#
import sys, os
import winreg
  
def extend():
    """
    extend() adds pypath and the Scripts under it to the PATH environment 
    variable as defined in the registry.  Already opened DOS-Command 
    prompts are not updated.
    """
    pypath = os.path.split(os.sys.executable)[0]
  
    hKey = winreg.OpenKey(winreg.HKEY_LOCAL_MACHINE,
                "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment",
                0, winreg.KEY_READ|winreg.KEY_SET_VALUE)
  
    value,typ = winreg.QueryValueEx(hKey, "PATH")
    vals = value.split(';')
    if pypath in vals:
        print (pypath, "already in the path.")
        return
    scriptspath = os.path.join(pypath,"Scripts")
    vals.append(pypath)
    vals.append(scriptspath)
    print ("Adding to PATH:", pypath)
    winreg.SetValueEx(hKey,"PATH",0,typ,';'.join(vals))
    winreg.FlushKey(hKey)
  
  
if __name__ == '__main__':
    extend()
  
